/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import enemeez.simplefarming.init.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;

public class FruitLeavesBlock
extends Block
implements IGrowable,
IForgeShearable {
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private final Supplier<Item> itemSupplier;
    private final Supplier<Item> saplingItemSupplier;

    public FruitLeavesBlock(AbstractBlock.Properties properties, Supplier<Item> itemSupplier, Supplier<Item> saplingItemSupplier) {
        super(properties);
        this.itemSupplier = itemSupplier;
        this.saplingItemSupplier = saplingItemSupplier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.itemSupplier.get());
    }

    public ItemStack getSapling(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.saplingItemSupplier.get());
    }

    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)DISTANCE) == 7 && (Boolean)state.func_177229_b((Property)PERSISTENT) == false || !this.isMaxAge(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE) == 7) {
            FruitLeavesBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        } else {
            int age = (Integer)state.func_177229_b((Property)AGE);
            if (age < 7 && worldIn.func_205049_d(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        world.func_180501_a(pos, FruitLeavesBlock.updateDistance(state, (IWorld)world, pos), 3);
    }

    public int func_200011_d(BlockState p_200011_1_, IBlockReader p_200011_2_, BlockPos p_200011_3_) {
        return 1;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState state2, IWorld world, BlockPos pos, BlockPos pos2) {
        int i = FruitLeavesBlock.getDistanceAt(state2) + 1;
        if (i != 1 || (Integer)state.func_177229_b((Property)DISTANCE) != i) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            i = Math.min(i, FruitLeavesBlock.getDistanceAt(worldIn.func_180495_p((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (ModBlocks.fruit_log == neighbor.func_177230_c()) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof FruitLeavesBlock ? (Integer)neighbor.func_177229_b((Property)DISTANCE) : 7;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!p_180655_2_.func_175727_C(p_180655_3_.func_177984_a()) || p_180655_4_.nextInt(15) != 1 || (blockstate = p_180655_2_.func_180495_p(blockpos = p_180655_3_.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)p_180655_2_, blockpos, Direction.UP))) {
            double d0 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
            double d1 = (double)p_180655_3_.func_177956_o() - 0.05;
            double d2 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
            p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FruitLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.TRUE), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISTANCE, PERSISTENT, AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public BlockState setValueAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int newAge = Math.min(7, (Integer)state.func_177229_b((Property)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }
}

